/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.SFPSelectServiceableEventsBean;
import com.ibm.hsc.client.PIHMCStringDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCFrameClient;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommandsTask;
import com.ibm.hsc.command.PICmdOutputUtils;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusSystemEventLog;
import com.ibm.hsc.common.util.CECInfo;
import com.ibm.hsc.common.util.DateFormatter;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hsc.websm.sfp.SelectServiceableEvent;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Vector;

public class HMCEventsList
extends HMCCommandsTask {
    private static final String MINS_PARAM = "-i";
    private static final String PROBLEM_NUM_FORMAT = "problem_num";
    private static final String PMH_NUM_FORMAT = "pmh_num";
    private static final String REFCODE_FORMAT = "refcode";
    private static final String STATUS_FORMAT = "status";
    private static final String FIRST_TIME_FORMAT = "first_time";
    private static final String LAST_TIME_FORMAT = "last_time";
    private static final String CREATED_TIME_FORMAT = "created_time";
    private static final String SYS_NAME_FORMAT = "sys_name";
    private static final String SYS_MTMS_FORMAT = "sys_mtms";
    private static final String ENCLOSURE_MTMS_FORMAT = "enclosure_mtms";
    private static final String FIRMWARE_FIX_FORMAT = "firmware_fix";
    private static final String TEXT_FORMAT = "text";
    private static final String REPORTING_NAME_FORMAT = "reporting_name";
    private static final String REPORTING_MTMS_FORMAT = "reporting_mtms";
    private static final String FAILING_MTMS_FORMAT = "failing_mtms";
    private static final String ANALYZING_HMC_FORMAT = "analyzing_hmc";
    private static final String[] validHardware = new String[]{"problem_num", "pmh_num", "refcode", "status", "first_time", "last_time", "sys_name", "sys_mtms", "enclosure_mtms", "firmware_fix", "text", "created_time", "reporting_name", "reporting_mtms", "failing_mtms", "analyzing_hmc"};
    private static final String TIME_FORMAT = "time";
    private static final String[] validConsole = new String[]{"time", "text"};
    private static final String CONSOLE_PARAM = "console";
    private static final String HARDWARE_PARAM = "hardware";
    private static final String FILTER_STATUS = "status";
    private static final String FILTER_PROB_NUMS = "problem_nums";
    private static final String[] validFilters = new String[]{"status", "problem_nums"};
    private boolean consoleEvents;
    private boolean serviceableEvents;
    private String managedSystem;
    private String status;
    private String[] problemNums;
    private int numDays;
    private int numMins;
    private String days;
    private String mins;
    private boolean CECEvents;
    private String[] validKeys;
    private String[] actualKeys;
    private static final int NUM_VALID_PARMS = 7;
    private HashMap m_validParms = new HashMap(15, 0.5f);
    private boolean m_writeStatus;
    private boolean m_header;
    private String m_delimiter;
    private String m_format;

    private HMCEventsList(PIHSCCECClient pIHSCCECClient, boolean bl) {
        this.m_writeStatus = bl;
        this.m_header = false;
        this.m_delimiter = ",";
        this.m_format = null;
        this.m_validParms.put("-t", null);
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-d", null);
        this.m_validParms.put("-F", null);
        this.m_validParms.put("--header", null);
        this.m_validParms.put("--filter", null);
        this.m_validParms.put(MINS_PARAM, null);
    }

    public void performCommand() throws HException, SFPException {
        block16: {
            DateFormatter dateFormatter;
            block15: {
                String string = "";
                dateFormatter = DateFormatter.getDefaultInstance();
                if (!this.consoleEvents) break block15;
                Log[] logArray = null;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date());
                if (this.numDays == 0 && this.numMins != 0) {
                    calendar.add(12, -this.numMins);
                } else {
                    calendar.add(5, -this.numDays);
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                }
                Date date = calendar.getTime();
                logArray = Log.retrieve((Byte)new Byte(0), null, null, (Date)date, null, null, null, null);
                if (logArray == null) break block16;
                for (int i = 0; i < logArray.length; ++i) {
                    String string2;
                    PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.validKeys);
                    pIHMCStringDataBean.setKeyValue(TIME_FORMAT, dateFormatter.formatDateTime(logArray[i].getTimestamp()));
                    try {
                        string2 = new AusSystemEventLog(logArray[i]).getEventText().toString();
                    }
                    catch (MissingResourceException missingResourceException) {
                        string2 = "";
                    }
                    pIHMCStringDataBean.setKeyValue(TEXT_FORMAT, string2);
                    this.taskletOutput.addElement(pIHMCStringDataBean);
                }
                break block16;
            }
            if (this.serviceableEvents) {
                for (int i = 0; i < this.problemNums.length; ++i) {
                    PIProblem[] pIProblemArray = null;
                    pIProblemArray = SelectServiceableEvent.getMatchingServiceableEvents(this.status, this.problemNums[i], this.managedSystem, SFPSelectServiceableEventsBean.ALL_LABEL, SFPSelectServiceableEventsBean.ALL_LABEL, this.days, this.mins, SFPSelectServiceableEventsBean.ALL_LABEL, SFPSelectServiceableEventsBean.ALL_LABEL);
                    if (pIProblemArray == null) continue;
                    String string = null;
                    for (int j = 0; j < pIProblemArray.length; ++j) {
                        PIHMCStringDataBean pIHMCStringDataBean = new PIHMCStringDataBean(this.validKeys);
                        pIHMCStringDataBean.setKeyValue(PROBLEM_NUM_FORMAT, Integer.toString(pIProblemArray[j].getProblemNumber()));
                        string = pIProblemArray[j].getPMH();
                        if (string != null) {
                            pIHMCStringDataBean.setKeyValue(PMH_NUM_FORMAT, string);
                        }
                        if ((string = pIProblemArray[j].getRefcode()) != null) {
                            pIHMCStringDataBean.setKeyValue(REFCODE_FORMAT, string);
                        }
                        pIHMCStringDataBean.setKeyValue("status", pIProblemArray[j].isProblemClosed() ? SFPSelectServiceableEventsBean.CLOSED_LABEL : SFPSelectServiceableEventsBean.OPEN_LABEL);
                        pIHMCStringDataBean.setKeyValue(FIRST_TIME_FORMAT, dateFormatter.formatDateTime(pIProblemArray[j].getFirstReportedTimestamp()));
                        pIHMCStringDataBean.setKeyValue(LAST_TIME_FORMAT, dateFormatter.formatDateTime(pIProblemArray[j].getLastReportedTimestamp()));
                        pIHMCStringDataBean.setKeyValue(SYS_NAME_FORMAT, SelectServiceableEvent.getReportingName(pIProblemArray[j]));
                        pIHMCStringDataBean.setKeyValue(SYS_MTMS_FORMAT, SelectServiceableEvent.getReportingMTMS(pIProblemArray[j]));
                        pIHMCStringDataBean.setKeyValue(ENCLOSURE_MTMS_FORMAT, SelectServiceableEvent.getFailingMTMS(pIProblemArray[j]));
                        if (pIProblemArray[j].getProblemData() != null) {
                            try {
                                LocalizableText localizableText = (LocalizableText)pIProblemArray[j].getProblemData().get((Object)"pdc_FIRMWARE_FIX");
                                if (localizableText != null) {
                                    pIHMCStringDataBean.setKeyValue(FIRMWARE_FIX_FORMAT, localizableText.toString());
                                }
                            }
                            catch (ClassCastException classCastException) {
                                // empty catch block
                            }
                        }
                        if ((string = pIProblemArray[j].getServiceableEventText()) != null) {
                            pIHMCStringDataBean.setKeyValue(TEXT_FORMAT, string);
                        }
                        pIHMCStringDataBean.setKeyValue(CREATED_TIME_FORMAT, dateFormatter.formatDateTime(pIProblemArray[j].getServiceableEventCreationTimestamp()));
                        pIHMCStringDataBean.setKeyValue(REPORTING_NAME_FORMAT, SelectServiceableEvent.getReportingName(pIProblemArray[j]));
                        pIHMCStringDataBean.setKeyValue(REPORTING_MTMS_FORMAT, SelectServiceableEvent.getReportingMTMS(pIProblemArray[j]));
                        pIHMCStringDataBean.setKeyValue(FAILING_MTMS_FORMAT, SelectServiceableEvent.getFailingMTMS(pIProblemArray[j]));
                        pIHMCStringDataBean.setKeyValue(ANALYZING_HMC_FORMAT, SelectServiceableEvent.getAnalyzingHMC(pIProblemArray[j]));
                        this.taskletOutput.addElement(pIHMCStringDataBean);
                    }
                }
            }
        }
    }

    public void mapParameters(HashMap hashMap) throws PIHscClientException, SFPException {
        Cloneable cloneable;
        Object var2_2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        this.consoleEvents = false;
        this.serviceableEvents = false;
        this.managedSystem = SFPSelectServiceableEventsBean.ALL_LABEL;
        this.validKeys = null;
        this.problemNums = new String[]{SFPSelectServiceableEventsBean.ALL_LABEL};
        this.status = SFPSelectServiceableEventsBean.ALL_LABEL;
        string = (String)hashMap.get("-t");
        string2 = (String)hashMap.get("-m");
        this.days = (String)hashMap.get("-d");
        this.m_format = (String)hashMap.get("-F");
        string3 = (String)hashMap.get("--header");
        string4 = (String)hashMap.get("--filter");
        this.mins = (String)hashMap.get(MINS_PARAM);
        if (string == null) {
            String[] stringArray = new String[]{HMCCommandUtils.TYPE_PARAM};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if ((string = string.trim()).equals(CONSOLE_PARAM)) {
            this.consoleEvents = true;
            this.validKeys = validConsole;
            if (string2 != null) {
                String[] stringArray = new String[]{"-m"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_COMBINATION", stringArray, null);
            }
            if (string4 != null) {
                String[] stringArray = new String[]{"--filter"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_COMBINATION", stringArray, null);
            }
        } else if (string.equals(HARDWARE_PARAM)) {
            Object object;
            int n;
            int n2;
            this.serviceableEvents = true;
            this.validKeys = validHardware;
            if (string2 != null) {
                this.managedSystem = string2.trim();
                if (this.managedSystem.length() == 0) {
                    String[] stringArray = new String[]{"-m"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
                }
                int n3 = this.managedSystem.indexOf(42);
                if (n3 > 0 && n3 < this.managedSystem.length() - 1 && n3 == this.managedSystem.lastIndexOf(42)) {
                    this.managedSystem = this.managedSystem.replace('*', '/');
                } else {
                    cloneable = SFPUtil.getMachineInfo();
                    if (cloneable != null) {
                        n2 = ((Vector)cloneable).size();
                        for (n = 0; n < n2; ++n) {
                            object = (CECInfo)((Vector)cloneable).elementAt(n);
                            if (!this.managedSystem.equals(((CECInfo)object).getCECMachineName())) continue;
                            this.managedSystem = ((CECInfo)object).getCECModelType() + '/' + ((CECInfo)object).getCECSerialNumber();
                            break;
                        }
                    }
                }
            }
            if (string4 != null) {
                cloneable = PIHMCCommandUtils.parseFilter(string4, validFilters);
                String string5 = (String)((HashMap)cloneable).get(FILTER_PROB_NUMS);
                if (string5 != null) {
                    this.problemNums = PIHMCCommandUtils.parseList(string5, ",");
                    for (n2 = 0; n2 < this.problemNums.length; ++n2) {
                        try {
                            n = Integer.parseInt(this.problemNums[n2]);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            object = new String[]{"problem_nums=" + string5};
                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_VALUE", (String[])object, null);
                        }
                    }
                }
                if ((string5 = (String)((HashMap)cloneable).get("status")) != null) {
                    n2 = 0;
                    n = 0;
                    object = PIHMCCommandUtils.parseList(string5, ",");
                    for (int i = 0; i < ((String[])object).length; ++i) {
                        if (((String)object[i]).trim().equalsIgnoreCase("open")) {
                            n2 = 1;
                            continue;
                        }
                        if (((String)object[i]).trim().equalsIgnoreCase("closed")) {
                            n = 1;
                            continue;
                        }
                        String[] stringArray = new String[]{"status=" + string5};
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_FILTER_VALUE", stringArray, null);
                    }
                    if (n2 != 0 && n != 0) {
                        this.status = SFPSelectServiceableEventsBean.ALL_LABEL;
                    } else if (n2 != 0) {
                        this.status = SFPSelectServiceableEventsBean.OPEN_LABEL;
                    } else if (n != 0) {
                        this.status = SFPSelectServiceableEventsBean.CLOSED_LABEL;
                    }
                }
            }
        } else {
            String[] stringArray = new String[]{"-t"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
        }
        if (this.mins != null && this.days != null) {
            String[] stringArray = new String[]{"-d, -i"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
        if (this.mins != null) {
            this.numDays = 0;
            this.days = "0";
            this.mins = this.mins.trim();
            try {
                this.numMins = Integer.parseInt(this.mins);
            }
            catch (NumberFormatException numberFormatException) {
                cloneable = new String[]{MINS_PARAM};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", (String[])cloneable, null);
            }
        } else {
            this.numMins = 0;
            this.mins = "0";
            if (this.days != null) {
                this.days = this.days.trim();
                try {
                    this.numDays = Integer.parseInt(this.days);
                }
                catch (NumberFormatException numberFormatException) {
                    cloneable = new String[]{"-d"};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", (String[])cloneable, null);
                }
            } else {
                this.numDays = 7;
                this.days = SFPSelectServiceableEventsBean.ALL_LABEL;
            }
        }
        if (this.m_format != null && this.m_format.length() > 0) {
            this.m_delimiter = PICmdOutputUtils.getFormatDelimiter(this.m_format, this.validKeys, this.validKeys.length);
            if (this.m_delimiter.length() == 0) {
                this.m_delimiter = ",";
            }
            this.actualKeys = PICmdOutputUtils.checkKeys(this.validKeys, this.m_format, this.m_delimiter);
        } else {
            this.actualKeys = this.validKeys;
        }
        if (string3 != null) {
            if (this.m_format == null) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_HEADER_PARM", null, null);
            }
            if (string3.trim().length() != 0) {
                String[] stringArray = new String[]{"--header"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARM_VALUE", stringArray, null);
            }
            this.m_header = true;
        }
    }

    public void printResults(int n, PrintStream printStream) {
        PICmdOutputUtils.printResults(printStream, this.m_writeStatus, this.taskletOutput.elements(), this.actualKeys, this.m_delimiter, this.m_header, this.m_format == null);
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "LSSVCEVENTS_HELP"));
    }

    public static int callCommandFromRouter(PIHSCFrameClient pIHSCFrameClient, PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        HMCEventsList hMCEventsList = new HMCEventsList(pIHSCCECClient, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, hMCEventsList.m_validParms);
            hMCEventsList.mapParameters(hashMap);
            n = hMCEventsList.invokeViaTasklet();
            hMCEventsList.printResults(n, printStream);
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                pIHscClientException.printStackTrace(printStream);
                String string = pIHscClientException.getMessage();
                if (string == null) {
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (HSCException hSCException) {
            if (bl) {
                printStream.print('\u0001');
            }
            hSCException.printStackTrace(printStream);
            String string = hSCException.getMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            printStream.println(string);
            n = 1;
        }
        catch (SFPException sFPException) {
            if (bl) {
                printStream.print('\u0001');
            }
            sFPException.printStackTrace(printStream);
            String string = sFPException.getLocalizedMessage();
            if (string == null) {
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "COMMAND_LINE_ERROR");
            }
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

